package com.javaskool.example;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Remove;
import javax.ejb.Stateful;

@Stateful(mappedName = "ccc")
public class ShoppingCartBean implements ShoppingCart, ShoppingCartLocal
{
  public ArrayList cartItems;

  public ShoppingCartBean() {
  }

  public void addItem(String item) {
    cartItems.add(item);
  }

  public void removeItem(String item) {
    cartItems.remove(item);
  }

  public void setCartItems(ArrayList cartItems) {
    this.cartItems = cartItems;
  }

  public ArrayList getCartItems() {
    return cartItems;
  }

  @PostConstruct
  public void initialize() {
    cartItems = new ArrayList();
  }

  @PreDestroy
  public void exit() {
    System.out.println("Saved items list into database");
  }

  
}

